<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package _tk
 */

get_header(); ?>

	<div class="container margintop">
		
		<?php if (get_field('news_title','option')) { ?>
			<?php if (!get_field('section_left','option')) { ?>
				<div class="text-center">
			<?php } ?>
				<h3 class="page-title<?php if (get_field('section_title_border','option')) echo ' relative title-border'; ?><?php if (get_field('more_padding','option')) echo ' more-padding'; ?><?php if (get_field('section_left','option')) echo ' text-left'; ?>"><span>
					<?php
					if ( is_category() ) :
						single_cat_title();

					elseif ( is_tag() ) :
						single_tag_title();

					elseif ( is_author() ) :
						/* Queue the first post, that way we know
						 * what author we're dealing with (if that is the case).
						*/
						the_post();
						printf( __( 'Author: %s', '_tk' ), '<span class="vcard">' . get_the_author() . '</span>' );
						/* Since we called the_post() above, we need to
						 * rewind the loop back to the beginning that way
						 * we can run the loop properly, in full.
						 */
						rewind_posts();

					elseif ( is_day() ) :
						printf( __( 'Day: %s', '_tk' ), '<span>' . get_the_date() . '</span>' );

					elseif ( is_month() ) :
						printf( __( 'Month: %s', '_tk' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );

					elseif ( is_year() ) :
						printf( __( 'Year: %s', '_tk' ), '<span>' . get_the_date( 'Y' ) . '</span>' );

					elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
						_e( 'Asides', '_tk' );

					elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
						_e( 'Images', '_tk');

					elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
						_e( 'Videos', '_tk' );

					elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
						_e( 'Quotes', '_tk' );

					elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
						_e( 'Links', '_tk' );

					else :
						_e( 'Archives', '_tk' );

					endif;
					?>
				</span></h3>
			<?php if (!get_field('section_left','option')) { ?>
				</div>
			<?php } ?>
		<?php } ?>
		
		<div class="row">
			<?php if (get_field('show_sidebar','option')) { ?>
				<div class="col-sm-18<?php if (get_field('sidebar_position','option') == 'left') echo ' col-sm-push-6'; ?>">
			<?php } else { ?>
				<div class="col-sm-24">
			<?php } ?>

				<?php if ( have_posts() ) : ?>
					<div class="<?php if (get_field('blog_type','option') == 'masonry') echo ' grid grid-'.$blog_columns; else echo 'row'; ?>">
						<?php if (get_field('blog_type','option') == 'masonry') { ?>
							<div class="grid-sizer"></div>
							<div class="gutter-sizer"></div>
						<?php } ?>
						<?php $del = 100;
						while ( have_posts() ) : the_post(); ?>

							<?php get_template_part( 'elements/content', get_post_format() ); ?>
							
						<?php $del = $del + 150;
						endwhile; ?>
					</div>

					<?php _tk_content_nav( 'nav-below' ); ?>
					<?php _tk_pagination(); ?>

				<?php else : ?>

					<?php get_template_part( 'no-results', 'index' ); ?>

				<?php endif; ?>

			</div>

			<?php if (get_field('show_sidebar','option')) { ?>
				<div class="col-sm-6<?php if (get_field('sidebar_position','option') == 'left') echo ' col-sm-pull-18'; ?>">
					<?php get_sidebar(); ?>
				</div>
			<?php } ?>
		</div>
	</div>
<?php get_footer(); ?>
